(function() {
  //    FILE:EventListView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'jqueryui/datepicker', 'models/bookingstructures/BookingstructuresModel', 'collections/event/EventCollection', 'collections/timereport/TimereportCollection', 'models/time/TimeModel', 'views/event/EventView', 'views/addpanel/AddPanelView', 'views/menu/MenuView', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, DatePicker, BookingstructuresModel, EventCollection, TimereportCollection, TimeModel, EventView, AddPanelView, MenuView) {
    var EventListView;
    return EventListView = class EventListView extends Backbone.View {
      initialize(usr, eventsCol, obj, day) {
        this.usr = usr;
        this.eventsCol = eventsCol;
        this.obj = obj;
        this.eventsCol.on('create', this.__update_events_list, this);
        this.eventsCol.on('change', this.__update_events_list, this);
        this.timereportsCol = new TimereportCollection();
        this.timereportsCol.on('change', this.__update_timereports_alert, this);
        this.timereportsCol.fetch();
        this.bookingStructures = new BookingstructuresModel();
        this.bookingStructures.get_booking_structures(this.usr);
        if (day) {
          this.dayToShow = Moment(day);
        } else {
          this.dayToShow = Moment();
        }
        this.updated_times = -1;
        this.time = new TimeModel();
        //@eventsCol.get_day_events(@usr,@dayToShow,@obj)
        this.viewable = this.usr.__can_view_event_in_time_frame(this.dayToShow);
        return this.bookable = this.usr.__can_create_event_in_time_frame(this.dayToShow);
      }

      attributes() {
        return {
          'data-role': 'page',
          'data-name': 'EventListView'
        };
      }

      events() {
        return {
          'tap #id-btn-datepicker': 'btnDatePickerClicked',
          'tap #id-btn-datepicker-tomorrow': 'btnTomorrowClicked',
          'tap #id-btn-datepicker-yesterday': 'btnYesterdayClicked',
          'tap #id-ul-events > li': 'btnEventClicked',
          'tap #btn-menu-notification-timereport': 'btnPanelClicked',
          'tap #id-btn-panel': 'btnPanelClicked',
          //'tap #id-btn-add': 'btnMenuAddClicked'
          'tap #id-btn-add-event': 'btnAddEventClicked',
          //      'tap #id-btn-add-cancel' : 'btnCancelAddRequestClicked'

          //Click back => OBJECT VIEWINIG
          'tap #id-btn-backToObject': 'btnBackToObjectsClicked',
          'pageshow': 'pageShown',
          // SHIFTS HANDLING
          'tap .btn-shift': 'btnShiftClicked',
          // ACCPET BOOKING
          'tap .span-wrap-btns-booking > .btn': 'btnBookingStatusClicked',
          //POPUP CLOSE
          'tap .declineNoteCancel': 'btnDeclineNoteCancel',
          //POPUP CONFIRM
          'tap .declineNoteConfirm': 'btnDeclineNoteConfirm'
        };
      }

      render() {
        var previousView, template, ul;
        //@$el.empty()
        template = Handlebars.templates['EventListView'];
        previousView = 'none';
        if (this.obj) {
          previousView = this.obj.get('previousView');
        }
        ul = this.$el.find('#id-ul-events');
        if (ul) {
          ul.empty();
        }
        this.$el.html(template({
          user: this.usr.toJSON(),
          dayToShow: this.dayToShow.format('ddd Do MMM'),
          trND: this.timereportsCol.get_number_not_done_timereports(),
          previousView: previousView,
          viewable: this.viewable,
          bookable: this.bookable,
          holiday: this.usr.__get_holiday(this.dayToShow.format('YYYY-MM-DD'))
        }));
        this.$el.attr('id', 'id-EventListView');
        if (!this.obj) {
          this.$el.find('#id-h1-navbar-title').text(this.usr.get('usersFullName'));
          if (this.timereportsCol.get_number_not_done_timereports() === 0) {
            $('.bubble-timereports').hide();
            $('.notification-timereports').hide();
          } else {
            $('.bubble-timereports').show();
            $('.notification-timereports').show();
          }
        } else {
          this.$el.find('#id-h1-navbar-title').text(this.obj.get('objectName'));
          $('.notification-timereports').hide();
        }
        this.addSidePanel();
        return this.$el;
      }

      //HANDLING OF SIDE PANEL AND NAVIGATION
      addSidePanel() {
        //if window.media_query_min_width(768)
        if (!MenuView) {
          MenuView = require("views/menu/MenuView");
        }
        this.panel = new MenuView(this.usr, this.obj);
        this.panel.render();
        return this.$el.append(this.panel.el);
      }

      btnPanelClicked(event) {
        return this.panel.btnPanelClicked(event);
      }

      btnMenuNotificationClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return this.panel.__get_view_from_stack('TimereportListView');
      }

      //# END OF HANDLING NAVIGATION

        //DATE SELECTOR
      btnTomorrowClicked(event) {
        var tomorrow;
        event.preventDefault();
        event.stopPropagation();
        $.mobile.loading('show');
        tomorrow = this.dayToShow.add('days', 1);
        this.dayToShow = tomorrow;
        this.viewable = this.usr.__can_view_event_in_time_frame(tomorrow);
        this.bookable = this.usr.__can_create_event_in_time_frame(tomorrow);
        if (this.bookable) {
          this.$el.find('#id-btn-add-event').show();
        } else {
          this.$el.find('#id-btn-add-event').hide();
        }
        $('#id-btn-datepicker .ui-btn-text').text(tomorrow.format('dd Do MMM'));
        this.eventsCol.get_day_events(this.usr, tomorrow.format('YYYY-MM-DD'), this.obj);
        return this.eventsCol.trigger('change');
      }

      btnYesterdayClicked(event) {
        var yesterday;
        event.preventDefault();
        event.stopPropagation();
        $.mobile.loading('show');
        yesterday = this.dayToShow.subtract('days', 1);
        this.dayToShow = yesterday;
        this.viewable = this.usr.__can_view_event_in_time_frame(yesterday);
        this.bookable = this.usr.__can_create_event_in_time_frame(yesterday);
        if (this.bookable) {
          this.$el.find('#id-btn-add-event').show();
        } else {
          this.$el.find('#id-btn-add-event').hide();
        }
        $('#id-btn-datepicker .ui-btn-text').text(yesterday.format('dd Do MMM'));
        this.eventsCol.get_day_events(this.usr, yesterday.format('YYYY-MM-DD'), this.obj);
        return this.eventsCol.trigger('change');
      }

      btnDatePickerClicked(event) {
        var firstDay, selDate, that;
        event.preventDefault();
        event.stopPropagation();
        that = this;
        selDate = new Date(this.dayToShow.format('YYYY-MM-DD'));
        if (!this.usr.get('weekStartsOnSunday')) {
          firstDay = 1;
        } else {
          firstDay = 0;
        }
        $('#id-input-datepicker').datepicker({
          dateFormat: 'yy-mm-dd',
          firstDay: firstDay,
          maxDate: window.MAXDATE,
          onSelect: function(dateText, dtp) {
            $.mobile.loading('show');
            that.dayToShow = Moment(dateText, 'YYYY-MM-DD');
            that.viewable = that.usr.__can_view_event_in_time_frame(that.dayToShow);
            that.bookable = that.usr.__can_create_event_in_time_frame(that.dayToShow);
            if (that.bookable) {
              that.$el.find('#id-btn-add-event').show();
            } else {
              that.$el.find('#id-btn-add-event').hide();
            }
            $('#id-btn-datepicker .ui-btn-text').text(Moment(dateText).format('dd Do MMM'));
            that.eventsCol.get_day_events(that.usr, that.dayToShow, that.obj);
            return that.eventsCol.trigger('change');
          }
        });
        $('#id-input-datepicker').datepicker("option", "defaultDate", selDate);
        return $('#id-input-datepicker').datepicker('show');
      }

      btnEventClicked(event) {
        var btn, eventID, view;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        eventID = btn.attr('data-bookingID');
        if (eventID !== 'NOEVENTS') {
          event = this.eventsCol.findWhere({
            eventID: eventID
          });
          event.get_details_event(this.usr.get('sessionID'), 'type', this.dayToShow);
          this.bookingStructures.get_booking_structures(this.usr);
          if (!EventView) {
            EventView = require("views/event/EventView"); //MAKING SURE IS LOADED
          }
          view = new EventView(this.usr, this.bookingStructures, this.eventsCol, event, this.dayToShow, this.obj);
          return $.mobile.jqmNavigator.pushView(view, {
            transition: "none"
          });
        }
      }

      btnAddEventClicked(event) {
        var view;
        event.preventDefault();
        event.stopPropagation();
        if (!AddPanelView) {
          AddPanelView = require('views/addpanel/AddPanelView');
        }
        view = new AddPanelView(this.usr, this.eventsCol, this.obj, this.dayToShow, this.timereportsCol);
        return $.mobile.jqmNavigator.pushView(view, {
          transition: 'none'
        });
      }

      btnBookingStatusClicked(event) {
        var bookingLineID, btn, ev, eventID, li, requestObject, status, that;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        that = this;
        if (btn.hasClass('btn-yes')) {
          status = 1;
        } else {
          status = 0;
        }
        li = btn.parents('li');
        eventID = li.attr('data-bookingID');
        // To get the event by line id if exists in DOM
        bookingLineID = li.attr('data-bookingLineID') ? li.attr('data-bookingLineID') : "";
        if (bookingLineID) {
          ev = this.eventsCol.findWhere({
            'bookingLineID': bookingLineID
          });
        } else {
          ev = this.eventsCol.findWhere({
            'eventID': eventID
          });
        }
        bookingLineID = ev != null ? ev.get('bookingLineID') : void 0;
        requestObject = {
          'bookingLineID': bookingLineID,
          'eventID': eventID,
          'sessionID': this.usr.get('sessionID'),
          'acceptStatus': status
        };
        $.mobile.loading('show');
        return ev.set_booking_accept_status(requestObject).done(function(data, textStatus, jqXHR) {
          var jsonObj, popUp, popUpHtml;
          jsonObj = data;
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            return that.panel.__refresh_current_view();
          } else if (jsonObj.Result.error === "mandatoryNoteWhenDeclining") {
            popUpHtml = "<div data-role=\"popup\" id=\"popupAlert\" data-overlay-theme=\"a\" data-theme=\"c\" data-dismissible=\"false\" class=\"ui-corner-all\">";
            popUpHtml += '<div data-role="header" data-theme="a" class="ui-corner-top">';
            popUpHtml += `<h3>${jsonObj.Result.errorText}</h3>`;
            popUpHtml += '</div> <textarea id="id-input-booking-note"></textarea>';
            popUpHtml += `<a href=\"#\" data-eventID=\"${eventID}\" data-bookingLineID=\"${bookingLineID}\" data-role=\"button\" data-inline=\"true\" data-rel=\"back\" data-theme=\"c\" class=\"declineNoteConfirm\">Confirm</a>`;
            popUpHtml += `<a href=\"#\" data-eventID=\"${eventID}\" data-bookingLineID=\"${bookingLineID}\" data-role=\"button\" data-inline=\"true\" data-rel=\"back\" data-theme=\"c\" class=\"declineNoteCancel\">Cancel</a>`;
            that.$el.append(popUpHtml);
            popUp = that.$el.find('#popupAlert');
            popUp.popup();
            popUp.trigger('create');
            return popUp.popup('open');
          }
        }).fail(function(data, textStatus, jqXHR) {
          return false;
        }).always(function(data, textStatus) {
          return $.mobile.loading('hide');
        });
      }

      btnShiftClicked(event) {
        var availability, btn, eventID, li;
        event.preventDefault();
        event.stopPropagation();
        btn = $(event.currentTarget);
        li = btn.parents('li');
        eventID = li.attr('data-eventID');
        if (btn.hasClass('btn-yes')) {
          li.removeClass('available').addClass('unavailable');
          btn.removeClass('btn-yes').addClass('btn-no');
          btn.find('.ui-btn-text').text('No');
          availability = 0;
        } else {
          li.removeClass('unavailable').addClass('available');
          btn.removeClass('btn-no').addClass('btn-yes');
          btn.find('.ui-btn-text').text('Yes');
          availability = 1;
        }
        $.mobile.loading('show');
        return this.usr.set_user_shift(eventID, availability).done(function(data, textStatus, jqXHR) {
          var jsonObj, ref, ref1;
          jsonObj = data;
          if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
            if ((ref = jsonObj.Result) != null ? ref.newEventID : void 0) {
              return li.attr('data-eventID', (ref1 = jsonObj.Result) != null ? ref1.newEventID : void 0);
            }
          } else {
            that.server_message = jsonObj.Result.Error;
            return that.trigger('shift_error');
          }
        }).fail(function(data, textStatus, jqXHR) {
          return false;
        }).always(function(data, textStatus) {
          return $.mobile.loading('hide');
        });
      }

      btnDeclineNoteCancel(event) {
        return this.$el.find('#popupAlert').remove();
      }

      btnDeclineNoteConfirm(event) {
        var bookingLineID, btn, ev, eventID, note, requestObject, that;
        note = this.$el.find('#id-input-booking-note').val();
        btn = $(event.currentTarget);
        bookingLineID = btn.attr('data-bookingLineID');
        eventID = btn.attr('data-eventID');
        requestObject = {
          'bookingLineID': bookingLineID,
          'eventID': eventID,
          'sessionID': this.usr.get('sessionID'),
          'declinedNote': note
        };
        if (bookingLineID) {
          ev = this.eventsCol.findWhere({
            'bookingLineID': bookingLineID
          });
        } else {
          ev = this.eventsCol.findWhere({
            'eventID': eventID
          });
        }
        that = this;
        this.$el.find('#popupAlert').remove();
        return ev.set_decline_note(requestObject).done(function(data, textStatus, jqXHR) {
          return that.panel.__refresh_current_view();
        });
      }

      pageShown(event) {
        if (!this.usr.__enabled_timereports()) {
          return this.$el.find('.notification-timereports').hide();
        } else {
          return this.__get_timereports_not_done();
        }
      }

      //@__update_events_list()
      //@setMenus(event)
      __update_events_list(col) {
        var events, hol, htmlHoliday, li, note, shiftHeader, that, ul, ulShifts;
        ul = this.$el.find('#id-ul-events');
        ulShifts = this.$el.find('#id-ul-shifts');
        ul.empty();
        ulShifts.empty();
        shiftHeader = '<li><h3>Available</h3></li>';
        ulShifts.append(shiftHeader);
        that = this;
        hol = this.usr.__get_holiday(this.dayToShow.format('YYYY-MM-DD'));
        if (hol) {
          htmlHoliday = '<td colspan="3" ><h3>' + hol.name + '</h3></td>';
          this.$el.find('#id-table-header-dates a').css({
            'color': '#FF3830'
          });
          this.$el.find('#id-btn-datepicker').css({
            'border': '1px solid #FF3830'
          });
          this.$el.find('#id-tr-holidays').html(htmlHoliday).show();
        } else {
          this.$el.find('#id-tr-holidays').hide();
          this.$el.find('#id-table-header-dates a').css({
            'color': '#006b82'
          });
          this.$el.find('#id-btn-datepicker').css({
            'border': '1px solid #006b82'
          });
        }
        if (col instanceof EventCollection) {
          events = col.get_cached_events(that.usr, that.dayToShow, that.obj);
          note = col.get_dayNote(that.dayToShow);
        } else {
          events = this.eventsCol.get_cached_events(that.usr, that.dayToShow, that.obj);
          note = this.eventsCol.get_dayNote(that.dayToShow);
        }
        //SORT BY INI TIME
        events.sort();
        if (note) {
          $('#id-p-dayNote').text(note.note);
          $('#id-p-dayNote').show();
        } else {
          $('#id-p-dayNote').hide();
        }
        if (events.length > 0) {
          _.each(events, function(ev) {
            return that.__print_li_event(ev, ul, ulShifts);
          });
          that.updated_times = 0;
        } else {
          if (this.viewable) {
            li = '<li class=\"liEvent\" data-bookingID="NOEVENTS">No events for this day</li>';
          } else {
            li = '<li class=\"liEvent\" data-bookingID="NOEVENTS">You can\'t see any events in this day</li>';
          }
          ul.append(li);
        }
        return ul.listview('refresh');
      }

      __print_li_event(ev, ul, ulShifts) {
        var bookingLineID, btnShift, eventID, involved, li, liS, mH, preliminary, sH, shiftClass, span, timeIn, timeOut, type;
        type = ev.get('type');
        if (type !== 'undisclosed') {
          mH = ev.get('mainHeader');
          sH = ev.get('subHeader');
        } else {
          mH = 'undisclosed';
          sH = '';
        }
        timeIn = this.time.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), parseFloat(ev.get('timeIn')));
        timeOut = this.time.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), parseFloat(ev.get('timeOut')));
        eventID = ev.get('eventID');
        bookingLineID = ev.get('bookingLineID') ? ev.get('bookingLineID') : "";
        if (ev.get('isPreliminary')) {
          preliminary = "<span class='spanPreliminary'></span>";
        } else {
          preliminary = "";
        }
        li = `<li class=\"liEvent \" data-bookingID=\"${eventID}\" data-bookingLineID=\"${bookingLineID}\">`;
        if (ev.__is_all_day()) {
          li += "<span class='spanTimeEvent'>All Day</span>";
        } else {
          li += `<span class='spanTimeEvent'>${timeIn}<br/>${timeOut}</span>`;
        }
        li += "<span class='spanSeparator'/>";
        if (type === 'request') {
          li += `<span class='header' >${preliminary} Request</span>`;
          li += `<span class='subheader1'>${mH}</span>`;
          if (ev.get('requestStatus') === 'pending') {
            if (ev.get('requestIsSpecial') === 1) {
              span = '<span style="color:darkgreen;font-size: 20px;" class="request-status">&bull;</span>';
            } else if (ev.get('requestIsSpecial2') === 1) {
              span = '<span style="color:pink;font-size: 20px;" class="request-status">&bull;</span>';
            } else {
              span = '<span style="color:yellow;font-size: 20px;" class="request-status">&bull;</span>';
            }
          } else if (ev.get('requestStatus') === 'accepted') {
            span = '<span style="color:#5BBA5C;font-size: 20px;" class="request-status">&bull;</span>';
          } else if (ev.get('requestStatus') === 'declined') {
            span = '<span style="color:darkred;font-size: 20px;" class="request-status">&bull;</span>';
          } else if (ev.get('requestStatus') === 'cancelled') {
            span = '<span style="color:darkred;font-size: 20px;" class="request-status">&bull;</span>';
          } else {
            li += "<br/>";
          }
          li += `<span class='subheader2'>${span} ${sH}</span>`;
          if (type !== 'undisclosed') {
            li += "<span class='fwi-arrow-right arrow-right'/>";
          }
          li += "</li>";
          return ul.append(li);
        } else if (type === 'shift') {
          ulShifts.show();
          timeIn = this.time.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), parseFloat(ev.get('timeIn')));
          timeOut = this.time.get_time_string_from_float(parseInt(this.usr.get('dayStartsAt'), 10), parseInt(this.usr.get('usesAMPM'), 10), parseFloat(ev.get('timeOut')));
          eventID = ev.get('eventID');
          mH = ev.get('mainHeader');
          if (ev.get('userIsAvailable')) {
            shiftClass = 'available';
            btnShift = "<a href='#' class='btn btn-shift btn-yes' data-role='button'>Yes</a>";
          } else {
            shiftClass = 'unavailable';
            btnShift = "<a href='#' class='btn btn-shift btn-no' data-role='button'>No</a>";
          }
          liS = `<li class=\"liEvent ${shiftClass}\" data-eventID=\"${eventID}\">`;
          liS += `<span class='spanTimeEvent'><span>${timeIn}<br/>${timeOut}</span></span>`;
          liS += `<span class='header'>${mH}</span>`;
          liS += `<span style='float: right;'>${btnShift}</span> `;
          liS += "</li>";
          ulShifts.append(liS);
          return ulShifts.find('.btn-shift').button(); //IS A BOOKING
        } else {
          span = '';
          if (!ev.get('isTimereported') && !ev.get('isPreliminary')) {
            span = '<span style="color:darkred;font-size: 20px;" class="request-status">&bull;</span>';
          }
          involved = ev.get('involvedHeader');
          li += `<span class='header' >${preliminary} ${span} ${mH}</span>`;
          if (involved) {
            li += `<span class='subheader1'> ${involved}</span>`;
          } else {
            li += "<br/>";
          }
          if (sH) {
            li += `<span class='subheader2'>${sH}</span>`;
          } else {
            li += "<br>";
          }
          if (type !== 'undisclosed') {
            li += "<span class='fwi-arrow-right arrow-right'/>";
          }
          if (ev.get('acceptStatus') === -1) {
            li += "<span class='span-wrap-btns-booking'><a href='#' class='btn btn-yes btn-accept-booking' data-role='button'>Accept</a><a href='#' class='btn btn-no btn-decline-booking' data-role='button'>Decline</a> </span>";
          }
          li += "</li>";
          ul.append(li);
          return ul.find('.btn').button();
        }
      }

      __update_timereports_alert() {
        var str;
        str = "&nbsp;" + this.timereportsCol.get_number_not_done_timereports() + "&nbsp;";
        return $('.bubble-timereports').html(str);
      }

      __get_timereports_not_done() {
        var diffMinutes, diffMs, lastUpdate, now;
        now = Moment();
        lastUpdate = Moment(this.usr.get('timereport_updated_at'), 'YYYY-MM-DD hh:mm:ss');
        diffMs = now - lastUpdate;
        diffMinutes = Math.round(((diffMs % 86400000) % 3600000) / 60000);
        if (diffMinutes > 0) {
          //console.log 'SERVER UPGRADE'
          return this.timereportsCol.get_not_done_timereports(this.usr);
        } else {
          return this.timereportsCol.fetch();
        }
      }

      __get_number_timereports_not_done() {
        return this.timereportsCol.get_number_not_done_timereports();
      }

      btnBackToObjectsClicked(event) {
        event.preventDefault();
        event.stopPropagation();
        return $.mobile.jqmNavigator.popView({
          transition: 'none'
        });
      }

    };
  });

}).call(this);
